/**
* \file: PluginManager.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_PLUGINMANAGER_H
#define CARPLAY_PLUGINMANAGER_H

#include <string>
#include <vector>
#include "IConfiguration.h"

namespace adit { namespace carplay
{

class CARPLAY_HIDDEN PluginManager
{
public:
    ~PluginManager();

    bool Initialize(IDynamicConfiguration& inConfig);

private:
    struct Library
    {
        void* Handle;
        std::string Name;
    };

    std::vector<Library> libraries;

    void load(const std::string& inName, IDynamicConfiguration& inConfig);
};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_PLUGINMANAGER_H */
